DROP TYPE tabla_detalleActa;
DROP TYPE tabla_detalleActaCompleto;
DROP TYPE TABLA_DETALLEDELEGSINDCONV;
DROP TYPE tabla_empresavariospreavisos;
DROP TYPE tabla_numeroactasregdef;
DROP TYPE tabla_resoldeneglaudoneg;
DROP TYPE TABLA_COMIMPUGRESUELTAS;
DROP TYPE TABLA_CABDELEGSINDCONV; 
DROP TYPE CABDELEGSINDCONV;
DROP TYPE detalleActa;
DROP TYPE DETALLEDELEGSINDCONV; 
DROP TYPE empresavariospreavisos; 
DROP TYPE numeroactasregdef; 
DROP TYPE resoldeneglaudoneg; 
DROP TYPE string_agg_int; 
DROP TYPE string_agg_type; 
DROP TYPE detalleActaDatos; 
DROP TYPE COMIMPUGRESUELTAS; 
DROP TYPE TABLA_COMUNICACIONEMPRESA;
DROP TYPE COMUNICACIONEMPRESA;
DROP TYPE COMEXTRACCIONDATOS;
DROP TYPE TABLA_COMEXTRACCIONDATOS;
DROP TYPE detalleActaDatosComp;


COMMIT;

CREATE OR REPLACE TYPE      CABDELEGSINDCONV IS OBJECT  (totalelectores NUMBER,
                 totalvotos NUMBER,
                 empresa  VARCHAR2(10),
                 numcentros NUMBER);
/
/* **************************************************************************************************** */				 
CREATE OR REPLACE TYPE detalleActa IS object  (numRegDef NUMBER,
                 fechaEntrada DATE,
                 numEntrada  VARCHAR2(15),
                 numActa NUMBER,
                 cif VARCHAR2(10),
                 numCentro NUMBER,
                 razonSocial VARCHAR2(50),
                 direccion VARCHAR2(50),
                 numTrabajadores NUMBER,
                 numRepresentantes NUMBER,
                 territorio VARCHAR2(2),
                 anoActa NUMBER,
                 nactaintcompleto VARCHAR2(15),
                 provincia varchar2(2),
                 municipio varchar2(3),
                 seccion varchar2(2),
                 ver NUMBER)
/             
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE DETALLEDELEGSINDCONV IS object  (
                 nacta NUMBER,
                 anoacta NUMBER,
                 territ VARCHAR2(2),
                 ver NUMBER,
                 codSindicato NUMBER,
                 siglas VARCHAR2(10),
                 sinddesc VARCHAR2(250),
                 sinddese VARCHAR2(250),
                 tipoconvenio  VARCHAR2(1),
                 numdelegados NUMBER,
                 nregdef  NUMBER,
                 anoregdef NUMBER,
                 ncentro NUMBER,
                 cif VARCHAR2(10),
                 razon VARCHAR2(50),
                 felec DATE,
                 fechaactu DATE)
/
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE      empresavariospreavisos IS OBJECT  (cif VARCHAR2(10),
                 codigocentro NUMBER,
                 razon  VARCHAR2(50),
                 fechaentrada DATE,
                 numpreaviso VARCHAR2(15),
                 numpreavisoint NUMBER,
                 fechainicio DATE,
                 municipio VARCHAR2(50),
                 preavisoglobal VARCHAR2(1),
                 observaciones VARCHAR2(500),
                 promotores VARCHAR2(10000),
                 promotoreseu VARCHAR2(10000),
                 territ VARCHAR2(2));
/
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE      numeroactasregdef IS OBJECT  (
                 numeroactas NUMBER
                 );
/
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE      resoldeneglaudoneg IS OBJECT  (fechaEntrada DATE,
                 nacta NUMBER,
                 anoacta  NUMBER,
                 territ VARCHAR2(2),
                 npre NUMBER,
                 anopreaviso NUMBER,
                 razon VARCHAR2(50),
                 domicilio VARCHAR2(50),
                 municipio VARCHAR2(50),
                 numelectores NUMBER,
                 numrepresentantes NUMBER,
                 freque DATE,
                 fimpug DATE,
                 fregdef DATE);
/
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE string_agg_int AS OBJECT (
  total VARCHAR2(4000),


  static FUNCTION ODCIAggregateInitialize(sctx IN OUT string_agg_int )
  RETURN NUMBER,


  MEMBER FUNCTION ODCIAggregateIterate(self IN OUT string_agg_int, value IN VARCHAR2 )
  RETURN NUMBER,


  MEMBER FUNCTION ODCIAggregateTerminate(self IN string_agg_int, returnValue OUT VARCHAR2, flags IN NUMBER)
  RETURN NUMBER,


  MEMBER FUNCTION ODCIAggregateMerge(self IN OUT string_agg_int, ctx2 IN string_agg_int)
  RETURN NUMBER
);
/

create or replace TYPE BODY string_agg_int
IS
    STATIC FUNCTION odciaggregateinitialize(sctx IN OUT string_agg_int)
        RETURN NUMBER
    IS
    BEGIN
        sctx := string_agg_int(NULL);
        RETURN odciconst.success;
    END;
    MEMBER FUNCTION odciaggregateiterate(
        SELF    IN OUT   string_agg_int,
        VALUE   IN       VARCHAR2
    )
        RETURN NUMBER
    IS
    BEGIN
        SELF.total := SELF.total || '?' || VALUE;
        RETURN odciconst.success;
    END;
    MEMBER FUNCTION odciaggregateterminate(
        SELF          IN       string_agg_int,
        returnvalue   OUT      VARCHAR2,
        flags         IN       NUMBER
    )
        RETURN NUMBER
    IS
    BEGIN
        returnvalue := LTRIM(SELF.total, '?');
        RETURN odciconst.success;
    END;
    MEMBER FUNCTION odciaggregatemerge(
        SELF   IN OUT   string_agg_int,
        ctx2   IN       string_agg_int
    )
        RETURN NUMBER
    IS
    BEGIN
        SELF.total := SELF.total || ctx2.total;
        RETURN odciconst.success;
    END;
END;

/
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE string_agg_type AS OBJECT (
  total VARCHAR2(4000),


  static FUNCTION ODCIAggregateInitialize(sctx IN OUT string_agg_type )
  RETURN NUMBER,


  MEMBER FUNCTION ODCIAggregateIterate(self IN OUT string_agg_type, value IN VARCHAR2 )
  RETURN NUMBER,


  MEMBER FUNCTION ODCIAggregateTerminate(self IN string_agg_type, returnValue OUT VARCHAR2, flags IN NUMBER)
  RETURN NUMBER,


  MEMBER FUNCTION ODCIAggregateMerge(self IN OUT string_agg_type, ctx2 IN string_agg_type)
  RETURN NUMBER
);
/


create or replace
TYPE BODY STRING_AGG_TYPE
IS
    STATIC FUNCTION odciaggregateinitialize(sctx IN OUT string_agg_type)
        RETURN NUMBER
    IS
    BEGIN
        sctx := string_agg_type(NULL);
        RETURN odciconst.success;
    END;
    MEMBER FUNCTION odciaggregateiterate(
        SELF    IN OUT   string_agg_type,
        VALUE   IN       VARCHAR2
    )
        RETURN NUMBER
    IS
    BEGIN
        SELF.total := SELF.total || ',' || VALUE;
        RETURN odciconst.success;
    END;
    MEMBER FUNCTION odciaggregateterminate(
        SELF          IN       string_agg_type,
        returnvalue   OUT      VARCHAR2,
        flags         IN       NUMBER
    )
        RETURN NUMBER
    IS
    BEGIN
        returnvalue := LTRIM(SELF.total, ',');
        RETURN odciconst.success;
    END;
    MEMBER FUNCTION odciaggregatemerge(
        SELF   IN OUT   string_agg_type,
        ctx2   IN       string_agg_type
    )
        RETURN NUMBER
    IS
    BEGIN
        SELF.total := SELF.total || ctx2.total;
        RETURN odciconst.success;
    END;
END;
/
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE      TABLA_CABDELEGSINDCONV IS TABLE OF CABDELEGSINDCONV;
/
CREATE OR REPLACE TYPE tabla_detalleActa IS TABLE OF detalleActa;
/
CREATE OR REPLACE TYPE  tabla_detalleActaCompleto IS TABLE OF detalleActaDatos;
/
CREATE OR REPLACE TYPE  TABLA_DETALLEDELEGSINDCONV IS TABLE OF DETALLEDELEGSINDCONV;
/
CREATE OR REPLACE TYPE      tabla_empresavariospreavisos IS TABLE OF empresavariospreavisos; 
/
CREATE OR REPLACE TYPE      tabla_numeroactasregdef IS TABLE OF numeroactasregdef; 
/
CREATE OR REPLACE TYPE      tabla_resoldeneglaudoneg IS TABLE OF resoldeneglaudoneg;
/				 
/* **************************************************************************************************** */
CREATE OR REPLACE TYPE detalleActaDatos IS object  
         (       VERSION_016 number(2), 
         ANO_ACTA_016 number(4),
         N_ACTA_016 number(6),
         C_TERRIT_016 varchar2(2),
         N_PREAVISO_016 number(6),
         ANO_PREAVISO_016 number(4),
         C_CONV_016 number(4),
         DESC_013 varchar2(250),
         DESE_013 varchar2(250),
         DESC_017 varchar2(250),
         DESE_017 varchar2(250),
         CBAJA_016 number(2),
         F_ENTRA_016 Date,
         F_ELECC_016 Date,
         FREGLIB_016 Date,
         FREGDEF_016 Date,
         F_COMIS_016 Date,
         F_REQUE_016 Date,
         F_SUBREQ_016 Date,
         F_RETCOM_016 Date,
         F_PRRI_016 Date,
         F_BAJA_016 Date,
         FACTU_016 Date,
         TOTELEC_016 number(6),
         CANDH_016 number(6),
         CANDM_016 number(6),
         ANO_ACTTOT_016 number(4),
         N_ACTTOT_016 number(6),
         N_REG_016 varchar2(15),
         ANO_REGDEF_016 number(4),
         N_REGDEF_016 varchar2(20),
         ELECH_016 number(6),
         ELECM_016 number(6),
         S_COMI_016 varchar2(1),
         OBSERV_016 varchar2(500),
         USUA_016 varchar2(15),
         INSPEC_016 number(1),
         F_CONSTCOM_016 Date,
         VALIDADA_016 varchar2(1),
         REMITE_016 varchar2(150),
         CCIF_001 varchar2(10),
         NCEN_001 number(3),
         CPOSC_001 varchar2(10),
         DOMIC_001 varchar2(50),
         PROVINCIA varchar2(50),
         MUNICIPIO varchar2(50),
         MUN_001 varchar2(3),
         PROVC_001 number(2),
         RSOC_001 varchar2(50),
         LOCAL_001 varchar2(30),
         MAXDEL_016 number(5),
         delegados number(6),
         delegadosh number(5),
         delegadosm number(5),
         totalEscr number(6),
         totalDif number(6),
         escrHombres0 number(6),
         escrHombres1 number(6),
         escrMujeres0 number(6),
         escrMujeres1 number(6),
         difHombres0 number(6),
         difHombres1 number(6),
         difMujeres0 number(6),
         difMujeres1 number(6),
     ID_CENTRO_016 number(6)
)
/



/* **************************************************************************************************** */

CREATE OR REPLACE
TYPE      tabla_detalleActaCompleto IS TABLE OF detalleActaDatos;
/

/* **************************************************************************************************** */

CREATE OR REPLACE TYPE COMIMPUGRESUELTAS IS object  (
                 nacta NUMBER,
                 anoacta  NUMBER,
                 territ VARCHAR2(2),
                 razon VARCHAR2(50),
                 domicilio VARCHAR2(50),
                 municipio NUMBER,
                 provincia NUMBER,
                 nimpug VARCHAR2(10000),
                 codigopostal VARCHAR2(5),
                 orderby VARCHAR2(1))
/

/* **************************************************************************************************** */

CREATE OR REPLACE TYPE TABLA_COMIMPUGRESUELTAS IS TABLE OF COMIMPUGRESUELTAS;
/

/* **************************************************************************************************** */

CREATE OR REPLACE TYPE comunicacionempresa IS object  (
                 ver NUMBER,
                 fechaentrada DATE,
                 nacta  NUMBER,
                 anoacta NUMBER,
                 territ VARCHAR2(2),
                 numpreaviso NUMBER,
                 anopreaviso NUMBER,
                 cif VARCHAR2(10),
                 codcentro NUMBER,
                 numerocentro NUMBER,
                 razon VARCHAR2(50),
                 domicilio VARCHAR2(50),
                 municipio VARCHAR2(3),
                 provincia VARCHAR2(2),
                 codigopostal VARCHAR2(5),
                 numactaint NUMBER)
/

/* **************************************************************************************************** */

CREATE OR REPLACE TYPE tabla_comunicacionempresa IS TABLE OF comunicacionempresa;
/

/* **************************************************************************************************** */

CREATE OR REPLACE TYPE COMEXTRACCIONDATOS IS object  (
                 nacta NUMBER,
                 anoacta  NUMBER,
                 territ VARCHAR2(2),
                 nimpug NUMBER,
                 anoimpug NUMBER,
                 nlaudo NUMBER,
                 anolaudo NUMBER,
                 flaudo DATE,
                 arbitro VARCHAR2(250),
                 cif VARCHAR2(10),
                 razon VARCHAR2(50),
                 sindicatos VARCHAR2(5000),
                 voces VARCHAR2(5000),
                 orderby VARCHAR2(1)
                 )
/

/* **************************************************************************************************** */

CREATE OR REPLACE TYPE tabla_COMEXTRACCIONDATOS IS TABLE OF COMEXTRACCIONDATOS;
/

COMMIT;